// This is the main DLL file.

#using "CSharp.dll"

#include "stdafx.h"
#include "CppWrapper.h"
#include <msclr\auto_gcroot.h>
#include <string.h>


using namespace System;
using namespace System::Runtime::InteropServices; // Marshal

class CppWrapperPrivate
{
public: msclr::auto_gcroot<CSharp^> csharp;
};

CppWrapper::CppWrapper()
{
	_private = new CppWrapperPrivate();
	_private->csharp = gcnew CSharp();
}

void CppWrapper::CppWExcelRead(char* FileName, char* SheetName, long* int_vec, double* xx)
{

	// copy unmanaged character values to managed vector 
	const char * temp1a = (char *)FileName;
	const char * temp2a = (char *)SheetName;
	const char * myString = "Hello managed world (from the unmanaged world)!";
	String ^ myManagedString = Marshal::PtrToStringAnsi((IntPtr)(char *)myString);
	String ^ temp1 = Marshal::PtrToStringAnsi((IntPtr)(char *)temp1a);
	String ^ temp2 = Marshal::PtrToStringAnsi((IntPtr)(char *)temp2a);


	array<String^>^ _chr_vec = gcnew array<String^>{"two", "three"};

	// copy integer(4)/long values to managed vector 
	array<__int32>^ _int_vec = gcnew array<__int32>(4);
	Marshal::Copy(System::IntPtr((void *)int_vec), _int_vec, 0, 4);

	// copy real(8)/double values to managed vector 
	int temp = int_vec[2] * int_vec[3];
	array<double>^ _xx = gcnew array<double>(temp);
	Marshal::Copy(System::IntPtr((void *)xx), _xx, 0, temp);

	// run C# routine
	_private->csharp->CSExcelRead(_chr_vec, _int_vec, _xx);

	// retreive managed arrays from unmanaged arrays
	Marshal::Copy(_xx, 0, System::IntPtr((void *)xx), temp);

	// exit wrapper
	return;
}

CppWrapper::~CppWrapper()
{
	delete _private;
}

/*

For details about copying data between managed and unmanaged code, see:
https://msdn.microsoft.com/en-us/library/system.runtime.interopservices.marshal_methods(v=vs.110).aspx

For details about mapping from C++ to C# types, see:


Structure of approach based on: http://pragmateek.com/using-c-from-native-c-with-the-help-of-ccli-v2/
System::String is not meant to be CLI compliant, and this may result in errors in the future.

*/
